﻿using NUnit.Framework;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Inet.Viewer.Data
{

    [TestFixture]
    class TestLoader
    {
        private Loader createLoader(byte[] a)
        {
            Loader loader = new Loader();
            loader.Data = a;
            return loader;
        }
        [Test]
        public void TestReadInt()
        {
            {
                Loader loader = createLoader(new byte[] { 0x80, });
                Assert.AreEqual(0, loader.ReadInt());
            }

            {
                Loader loader = createLoader(new byte[] { 0x81, });
                Assert.AreEqual(1, loader.ReadInt());
            }

            {
                Loader loader = createLoader(new byte[] { 0xa1, });
                Assert.AreEqual(33, loader.ReadInt());
            }

            {
                Loader loader = createLoader(new byte[] { 0x76, 0x59, });
                Assert.AreEqual(13913, loader.ReadInt());
            }

            {
                Loader loader = createLoader(new byte[] { 0x21, 0x22, 0xfe, });
                Assert.AreEqual(74494, loader.ReadInt());
            }

            {
                Loader loader = createLoader(new byte[] { 0x11, 0x28, 0x89, 0xb9, });
                Assert.AreEqual(19433913, loader.ReadInt());
            }

            {
                Loader loader = createLoader(new byte[] { 0x0f, });
                Assert.AreEqual(-1, loader.ReadInt());
            }

            {
                Loader loader = createLoader(new byte[] { 0x08, });
                Assert.AreEqual(-8, loader.ReadInt());
            }

            {
                Loader loader = createLoader(new byte[] { 0x02, 0xb8, 0x0f, });
                Assert.AreEqual(-83953, loader.ReadInt());
            }
        }
    }
}
